/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <ctype.h>

#include "lx_route_file.h"
#include "lx_xbar_file.h"

#define lx_xbar_file_error(c,e){printf ("%d: ", (c));printf e; printf ("\n"); goto error;}
#define LX_XBAR_FILE_MAX_LINE 200

static char*lx_xbar_file_next_line (FILE*fp, char*line, int max_line, int*line_count, int allow_blank)
{
  char*s;
  insist (fp && line && max_line > 0 && line_count);

  while ((s = fgets (line, max_line, fp)))
  {
    (*line_count)++;
    while (isspace (*s))
      s++;
    if (*s || allow_blank) return s;
  }
  except: return 0;
}

int lx_xbar_file_read_xbars (FILE*fp, lx_map_t*m, int iport, lx_node_t*first, lx_xbar_table_entry_t*entries)
{
  int i, j, c, xbar, offset, line_count, last_port;
  char line [LX_XBAR_FILE_MAX_LINE + 1];
  lx_route_t r;
  lx_node_t*n;
  int f [6];
  char*s;

  insist (fp && m && entries && line_count);
  insist (iport >= 0 && iport < MI_MY_SIZE);
  insist (first && !first->xbar);
  
  line_count = 0;
  
  for (i = 0; i < m->num_xbars; i++)
  {
    if (!(s = lx_xbar_file_next_line (fp, line, LX_XBAR_FILE_MAX_LINE, &line_count, 0)))
      return 0;
    
    if ((c = sscanf (s, "%x:%x:%x:%x:%x:%x:%d:%d", f+0,  f+1,  f+2,  f+3,  f+4,  f+5, &xbar, &offset)) < 8 ||
	xbar <= 0 ||
	offset < 1 - LX_XBAR_SIZE || offset > LX_XBAR_SIZE)
      lx_xbar_file_error (line_count, ("bad xbar entry"));

    for (j = 0; j < 6; j++)
      entries [i].mac_address [j] = f [j];
    entries [i].xbar = xbar - 1;
    entries [i].offset = offset;

    if (!(s = lx_xbar_file_next_line (fp, line, LX_XBAR_FILE_MAX_LINE, &line_count, 1)))
      return 0;

    if (!lx_route_file_read_route (s, &r))
      lx_xbar_file_error (line_count, ("bad route"));
    
    if (!(n = lx_follow (first, iport, &r, &last_port)) ||
	!n->xbar)
      lx_xbar_file_error (line_count, ("route does not lead to xbar"));

    insist (n->index < m->num_xbars);
    entries [i].index = n->index;
  }
  
  return i;
  error:
  except: return 0;
}
